<!DOCTYPE html>
<html lang="fa">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>سامانه استخدام شرکت ملی نفت</title>
  <style>
    @font-face {
      font-family: 'BYekan';
      src: url('https://cdn.fontcdn.ir/Font/Persian/BYekan/BYekan.woff2') format('woff2');
    }

    * {
      box-sizing: border-box;
      margin: 0;
      padding: 0;
    }

    body {
      font-family: 'BYekan', sans-serif;
      background: #ffffff;
      color: #003366;
      direction: rtl;
      line-height: 1.9;
      padding: 0;
    }

    .top-header {
      background-color: #005bbb;
      color: white;
      text-align: center;
      padding: 18px 10px;
      font-size: 20px;
      font-weight: bold;
    }

    .banner {
      text-align: center;
      padding: 25px 15px 10px;
    }

    .banner img {
      max-width: 140px; /* بزرگ‌تر از قبل */
      height: auto;
    }

    .banner h2 {
      color: #005bbb;
      font-size: 22px;
      margin: 20px 0 12px;
    }

    .banner p {
      color: #333;
      font-size: 16px;
      line-height: 2.2;
    }

    .buttons {
      display: flex;
      flex-direction: column;
      align-items: center;
      gap: 12px;
      margin: 30px 0;
      padding: 0 20px;
    }

    .buttons a {
      width: 100%;
      max-width: 320px;
      text-decoration: none;
    }

    .btn {
      display: block;
      width: 100%;
      padding: 14px;
      text-align: center;
      font-size: 17px;
      font-weight: bold;
      border-radius: 8px;
      transition: 0.3s;
    }

    .btn-primary {
      background-color: #005bbb;
      color: white;
      border: none;
    }

    .btn-secondary {
      background-color: white;
      color: #005bbb;
      border: 2px solid #005bbb;
    }

    .btn:hover {
      opacity: 0.9;
    }

    footer {
      text-align: center;
      font-size: 13px;
      color: #888;
      padding-bottom: 20px;
    }
  </style>
</head>
<body>

  <div class="top-header">
    سامانه جامع استخدام شرکت ملی نفت ایران
  </div>

  <div class="banner">
    <!-- لوگو را با نام زیر ذخیره کن -->
    <img src="logo.png" alt="لوگو شرکت ملی نفت" />
    <h2>استخدام نیروی متخصص در شرکت ملی نفت ایران</h2>
    <p>
      فرصت‌های شغلی در سراسر کشور بدون نیاز به<br />
      پرداخت هیچ‌گونه هزینه یا پیش‌پرداخت
    </p>
  </div>

  <div class="buttons">
    <a href="form.html">
      <div class="btn btn-primary">ورود به سامانه</div>
    </a>
    <a href="#">
      <div class="btn btn-secondary">شرکت‌های زیرمجموعه</div>
    </a>
  </div>

  <footer>
  شرکت ملی پخش فرآورده های نفتی ایران 🛠️
  </footer>

</body>
</html>